import { Entity, Player, world } from "@minecraft/server";
import { ActionFormData } from "@minecraft/server-ui";
import { getClosestPlayerFromLocation } from "./utils";
import { getHostPlayer } from "./main";


const ENTITY_TOOL_SPAWNER_FORM = new ActionFormData()
  .title("Entity Tool Spawner")
  .body("Select the tool item to spawn")
  .button("Entity Rotator")
  .button("Entity Remover")
  .button("CCTV Linker");


function startEntityToolSpawnerFormOperation(entityToolSpawnerEntity: Entity, playerToSeeForm: Player) {
  ENTITY_TOOL_SPAWNER_FORM.show(playerToSeeForm).then(response => {
    if (entityToolSpawnerEntity === undefined || !entityToolSpawnerEntity.isValid()) return;

    if (response.canceled) {
      entityToolSpawnerEntity.triggerEvent("despawn");
      return;
    }

    let selectionIndex: number = response.selection!;
    switch (selectionIndex) {
      case 0:
        entityToolSpawnerEntity.runCommand('structure load scpd:item_entity_rotator ~ ~ ~');
        break;
      case 1:
        entityToolSpawnerEntity.runCommand('structure load scpd:item_entity_remover ~ ~ ~');
        break;
      case 2:
        entityToolSpawnerEntity.runCommand('structure load scpd:item_cctv_linker ~ ~ ~');
        break;
      default:
        playerToSeeForm.sendMessage('§cSomething went wrong.');
        break;
    }

    entityToolSpawnerEntity.triggerEvent("despawn");
  });
}

export function setupEntityToolSpawner() {
  world.afterEvents.entitySpawn.subscribe(event => {
    let spawnedEntity: Entity = event.entity;
    if (spawnedEntity.typeId !== "lc:scpd_entity_tool_spawner") return;

    let playerToSeeForm: Player = getClosestPlayerFromLocation(getHostPlayer(), spawnedEntity.location);

    startEntityToolSpawnerFormOperation(spawnedEntity, playerToSeeForm);
  });
}